/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.impl.cloudevent;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.client.tcp.EventMeshTCPPubClient;
import org.apache.eventmesh.client.tcp.common.AsyncRRCallback;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.ReceiveMsgHook;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.common.TcpClient;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.client.tcp.impl.AbstractEventMeshTCPPubHandler;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloudEventTCPPubClient
extends TcpClient
implements EventMeshTCPPubClient<CloudEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudEventTCPPubClient.class);
    private ReceiveMsgHook<CloudEvent> callback;
    private final ConcurrentHashMap<String, AsyncRRCallback> callbackConcurrentHashMap = new ConcurrentHashMap();

    public CloudEventTCPPubClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        super(eventMeshTcpClientConfig);
    }

    @Override
    public void init() throws EventMeshException {
        try {
            super.open(new CloudEventTCPPubHandler(this.contexts));
            super.hello();
            super.heartbeat();
        }
        catch (Exception ex) {
            throw new EventMeshException("Initialize EventMeshMessageTCPPubClient error", (Throwable)ex);
        }
    }

    @Override
    public void reconnect() throws EventMeshException {
        try {
            super.reconnect();
            super.hello();
        }
        catch (Exception ex) {
            throw new EventMeshException("reconnect error", (Throwable)ex);
        }
    }

    @Override
    public Package rr(CloudEvent event, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(event, Command.REQUEST_TO_SERVER);
            log.info("{}|rr|send|type={}|msg={}", new Object[]{CLIENTNO, msg, msg});
            return this.io(msg, timeout);
        }
        catch (Exception ex) {
            throw new EventMeshException("rr error", (Throwable)ex);
        }
    }

    @Override
    public void asyncRR(CloudEvent event, AsyncRRCallback callback, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(event, Command.REQUEST_TO_SERVER);
            super.send(msg);
            this.callbackConcurrentHashMap.put((String)RequestContext.key(msg), callback);
        }
        catch (Exception ex) {
            throw new EventMeshException("asyncRR error", (Throwable)ex);
        }
    }

    @Override
    public Package publish(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(cloudEvent, Command.ASYNC_MESSAGE_TO_SERVER);
            log.info("SimplePubClientImpl cloud event|{}|publish|send|type={}|protocol={}|msg={}", new Object[]{CLIENTNO, msg.getHeader().getCmd(), msg.getHeader().getProperty("protocoltype"), msg});
            return this.io(msg, timeout);
        }
        catch (Exception ex) {
            throw new EventMeshException("publish error", (Throwable)ex);
        }
    }

    @Override
    public void broadcast(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        try {
            Package msg = MessageUtils.buildPackage(cloudEvent, Command.BROADCAST_MESSAGE_TO_SERVER);
            log.info("{}|publish|send|type={}|protocol={}|msg={}", new Object[]{CLIENTNO, msg.getHeader().getCmd(), msg.getHeader().getProperty("protocoltype"), msg});
            super.send(msg);
        }
        catch (Exception ex) {
            throw new EventMeshException("Broadcast message error", (Throwable)ex);
        }
    }

    @Override
    public void registerBusiHandler(ReceiveMsgHook<CloudEvent> handler) throws EventMeshException {
        this.callback = handler;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception ex) {
            log.error("Close CloudEvent TCP publish client error", (Throwable)ex);
        }
    }

    @ChannelHandler.Sharable
    private class CloudEventTCPPubHandler
    extends AbstractEventMeshTCPPubHandler<CloudEvent> {
        public CloudEventTCPPubHandler(ConcurrentHashMap<Object, RequestContext> contexts) {
            super(contexts);
        }

        @Override
        public void callback(CloudEvent cloudEvent, ChannelHandlerContext ctx) {
            if (CloudEventTCPPubClient.this.callback != null) {
                CloudEventTCPPubClient.this.callback.handle(cloudEvent).ifPresent(responseMessage -> ctx.writeAndFlush((Object)MessageUtils.buildPackage(responseMessage, Command.RESPONSE_TO_SERVER)));
            }
        }

        @Override
        public CloudEvent getMessage(Package tcpPackage) {
            EventFormat eventFormat = EventFormatProvider.getInstance().resolveFormat("application/cloudevents+json");
            Preconditions.checkNotNull((Object)eventFormat, (Object)String.format("Cannot find the cloudevent format: %s", "application/cloudevents+json"));
            return eventFormat.deserialize(tcpPackage.getBody().toString().getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public void sendResponse(Package tcpPackage) {
            try {
                CloudEventTCPPubClient.this.send(tcpPackage);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

