/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.utils;

import com.alibaba.otter.canal.parse.driver.mysql.packets.HeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.IPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.PacketWithHeaderPacket;
import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelBufferHelper {
    protected final transient Logger logger = LoggerFactory.getLogger(ChannelBufferHelper.class);

    public final HeaderPacket assembleHeaderPacket(ChannelBuffer buffer) {
        HeaderPacket header = new HeaderPacket();
        byte[] headerBytes = new byte[4];
        buffer.readBytes(headerBytes);
        header.fromBytes(headerBytes);
        return header;
    }

    public final PacketWithHeaderPacket assembleBodyPacketWithHeader(ChannelBuffer buffer, HeaderPacket header, PacketWithHeaderPacket body) throws IOException {
        if (body.getHeader() == null) {
            body.setHeader(header);
        }
        this.logger.debug("body packet type:{}", body.getClass());
        this.logger.debug("read body packet with packet length: {} ", (Object)header.getPacketBodyLength());
        byte[] packetBytes = new byte[header.getPacketBodyLength()];
        this.logger.debug("readable bytes before reading body:{}", (Object)buffer.readableBytes());
        buffer.readBytes(packetBytes);
        body.fromBytes(packetBytes);
        this.logger.debug("body packet: {}", (Object)body);
        return body;
    }

    public final ChannelBuffer createHeaderWithPacketNumberPlusOne(int bodyLength, byte packetNumber) {
        HeaderPacket header = new HeaderPacket();
        header.setPacketBodyLength(bodyLength);
        header.setPacketSequenceNumber((byte)(packetNumber + 1));
        return ChannelBuffers.wrappedBuffer((byte[])header.toBytes());
    }

    public final ChannelBuffer createHeader(int bodyLength, byte packetNumber) {
        HeaderPacket header = new HeaderPacket();
        header.setPacketBodyLength(bodyLength);
        header.setPacketSequenceNumber(packetNumber);
        return ChannelBuffers.wrappedBuffer((byte[])header.toBytes());
    }

    public final ChannelBuffer buildChannelBufferFromCommandPacket(IPacket packet) throws IOException {
        byte[] bodyBytes = packet.toBytes();
        ChannelBuffer header = this.createHeader(bodyBytes.length, (byte)0);
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, ChannelBuffers.wrappedBuffer((byte[])bodyBytes)});
    }
}

