/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.consumer;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.eventmesh.client.http.AbstractHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.client.http.util.HttpUtils;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.common.ClientType;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshHttpConsumer
extends AbstractHttpClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshHttpConsumer.class);
    private final transient ThreadPoolExecutor consumeExecutor;
    private static final List<SubscriptionItem> SUBSCRIPTIONS = Collections.synchronizedList(new ArrayList());
    private final transient ScheduledThreadPoolExecutor scheduler;

    public EventMeshHttpConsumer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        this(eventMeshHttpClientConfig, null);
    }

    public EventMeshHttpConsumer(EventMeshHttpClientConfig eventMeshHttpClientConfig, ThreadPoolExecutor customExecutor) throws EventMeshException {
        super(eventMeshHttpClientConfig);
        this.consumeExecutor = Optional.ofNullable(customExecutor).orElseGet(() -> ThreadPoolFactory.createThreadPoolExecutor((int)eventMeshHttpClientConfig.getConsumeThreadCore(), (int)eventMeshHttpClientConfig.getConsumeThreadMax(), (String)"EventMesh-client-consume"));
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new EventMeshThreadFactory("HTTPClientScheduler", true));
    }

    public void subscribe(List<SubscriptionItem> topicList, String subscribeUrl) throws EventMeshException {
        Objects.requireNonNull(topicList, "Subscribe item cannot be null");
        Objects.requireNonNull(subscribeUrl, "SubscribeUrl cannot be null");
        RequestParam subscribeParam = this.buildCommonRequestParam().addHeader("code", RequestCode.SUBSCRIBE.getRequestCode()).addBody("topic", JsonUtils.toJSONString(topicList)).addBody("consumerGroup", this.eventMeshHttpClientConfig.getConsumerGroup()).addBody("url", subscribeUrl);
        String target = this.selectEventMesh();
        try {
            String subRes = HttpUtils.post(this.httpClient, target, subscribeParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.parseObject((String)subRes, EventMeshRetObj.class);
            if (Objects.requireNonNull(ret).getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
            SUBSCRIPTIONS.addAll(topicList);
        }
        catch (Exception ex) {
            throw new EventMeshException(String.format("Subscribe topic error, target:%s", target), (Throwable)ex);
        }
    }

    public void heartBeat(List<SubscriptionItem> topicList, String subscribeUrl) {
        Objects.requireNonNull(topicList, "Subscribe item cannot be null");
        Objects.requireNonNull(subscribeUrl, "SubscribeUrl cannot be null");
        this.scheduler.scheduleAtFixedRate(() -> {
            try {
                List heartbeatEntities = topicList.stream().map(subscriptionItem -> {
                    HeartbeatRequestBody.HeartbeatEntity heartbeatEntity = new HeartbeatRequestBody.HeartbeatEntity();
                    heartbeatEntity.setTopic(subscriptionItem.getTopic());
                    heartbeatEntity.setUrl(subscribeUrl);
                    return heartbeatEntity;
                }).collect(Collectors.toList());
                RequestParam requestParam = this.buildCommonRequestParam().addHeader("code", RequestCode.HEARTBEAT.getRequestCode()).addBody("clientType", ClientType.SUB.name()).addBody("heartbeatEntities", JsonUtils.toJSONString(heartbeatEntities));
                String target = this.selectEventMesh();
                String res = HttpUtils.post(this.httpClient, target, requestParam);
                EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.parseObject((String)res, EventMeshRetObj.class);
                if (EventMeshRetCode.SUCCESS.getRetCode().intValue() != Objects.requireNonNull(ret).getRetCode()) {
                    throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
                }
            }
            catch (Exception e) {
                log.error("send heartBeat error", (Throwable)e);
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void unsubscribe(List<String> topicList, String unSubscribeUrl) throws EventMeshException {
        Objects.requireNonNull(topicList, "Topics cannot be null");
        Objects.requireNonNull(unSubscribeUrl, "unSubscribeUrl cannot be null");
        RequestParam unSubscribeParam = this.buildCommonRequestParam().addHeader("code", RequestCode.UNSUBSCRIBE.getRequestCode()).addBody("topic", JsonUtils.toJSONString(topicList)).addBody("url", unSubscribeUrl);
        String target = this.selectEventMesh();
        try {
            String unSubRes = HttpUtils.post(this.httpClient, target, unSubscribeParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.parseObject((String)unSubRes, EventMeshRetObj.class);
            if (EventMeshRetCode.SUCCESS.getRetCode().intValue() != Objects.requireNonNull(ret).getRetCode()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
            SUBSCRIPTIONS.removeIf(item -> topicList.contains(item.getTopic()));
        }
        catch (Exception e) {
            throw new EventMeshException(String.format("Unsubscribe topic error, target:%s", target), (Throwable)e);
        }
    }

    @Override
    public void close() throws EventMeshException {
        log.info("LiteConsumer shutdown begin.");
        super.close();
        if (this.consumeExecutor != null) {
            this.consumeExecutor.shutdown();
        }
        this.scheduler.shutdown();
        log.info("LiteConsumer shutdown end.");
    }

    private RequestParam buildCommonRequestParam() {
        return new RequestParam(HttpMethod.POST).addHeader(ProtocolKey.ClientInstanceKey.ENV.getKey(), this.eventMeshHttpClientConfig.getEnv()).addHeader(ProtocolKey.ClientInstanceKey.IDC.getKey(), this.eventMeshHttpClientConfig.getIdc()).addHeader(ProtocolKey.ClientInstanceKey.IP.getKey(), this.eventMeshHttpClientConfig.getIp()).addHeader(ProtocolKey.ClientInstanceKey.PID.getKey(), this.eventMeshHttpClientConfig.getPid()).addHeader(ProtocolKey.ClientInstanceKey.SYS.getKey(), this.eventMeshHttpClientConfig.getSys()).addHeader(ProtocolKey.ClientInstanceKey.USERNAME.getKey(), this.eventMeshHttpClientConfig.getUserName()).addHeader(ProtocolKey.ClientInstanceKey.PASSWD.getKey(), this.eventMeshHttpClientConfig.getPassword()).addHeader("version", ProtocolVersion.V1.getVersion()).addHeader("language", "JAVA").setTimeout(15000L).addBody("consumerGroup", this.eventMeshHttpClientConfig.getConsumerGroup());
    }
}

