/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import com.sun.net.httpserver.HttpsExchange;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalsCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;

public class HttpServerAuthenticator
extends Authenticator {
    static final String REALM_PROPERTY_NAME = "httpServerAuthenticator.realm";
    static final String REQUEST_SUBJECT_ATTRIBUTE_PROPERTY_NAME = "httpServerAuthenticator.requestSubjectAttribute";
    static String DEFAULT_SUBJECT_ATTRIBUTE = "org.apache.activemq.artemis.jaasSubject";
    static final String DEFAULT_REALM = "http_server_authenticator";
    static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    final String realm = System.getProperty("httpServerAuthenticator.realm", "http_server_authenticator");
    final String subjectRequestAttribute = System.getProperty("httpServerAuthenticator.requestSubjectAttribute", DEFAULT_SUBJECT_ATTRIBUTE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            LoginContext loginContext = new LoginContext(this.realm, callbacks -> {
                for (Callback callback : callbacks) {
                    byte[] authHeaderBytes;
                    String method;
                    StringTokenizer stringTokenizer;
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        stringTokenizer = new StringTokenizer(this.extractAuthHeader(httpExchange));
                        method = stringTokenizer.nextToken();
                        if ("Basic".equalsIgnoreCase(method)) {
                            authHeaderBytes = Base64.getDecoder().decode(stringTokenizer.nextToken().getBytes(StandardCharsets.UTF_8));
                            byte[] password = Arrays.copyOfRange(authHeaderBytes, Arrays.binarySearch(authHeaderBytes, (byte)58) + 1, authHeaderBytes.length);
                            passwordCallback.setPassword(new String(password, StandardCharsets.UTF_8).toCharArray());
                            continue;
                        }
                        if (!"Bearer".equalsIgnoreCase(method)) continue;
                        passwordCallback.setPassword(stringTokenizer.nextToken().toCharArray());
                        continue;
                    }
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        stringTokenizer = new StringTokenizer(this.extractAuthHeader(httpExchange));
                        method = stringTokenizer.nextToken();
                        if (!"Basic".equalsIgnoreCase(method)) continue;
                        authHeaderBytes = Base64.getDecoder().decode(stringTokenizer.nextToken().getBytes(StandardCharsets.UTF_8));
                        byte[] user = Arrays.copyOfRange(authHeaderBytes, 0, Arrays.binarySearch(authHeaderBytes, (byte)58));
                        nameCallback.setName(new String(user, StandardCharsets.UTF_8));
                        continue;
                    }
                    if (callback instanceof CertificateCallback) {
                        HttpsExchange httpsExchange;
                        Certificate[] peerCerts;
                        CertificateCallback certCallback = (CertificateCallback)callback;
                        if (!(httpExchange instanceof HttpsExchange) || (peerCerts = (httpsExchange = (HttpsExchange)httpExchange).getSSLSession().getPeerCertificates()) == null || peerCerts.length <= 0) continue;
                        certCallback.setCertificates(new X509Certificate[]{(X509Certificate)peerCerts[0]});
                        continue;
                    }
                    if (callback instanceof PrincipalsCallback) {
                        PrincipalsCallback principalsCallback = (PrincipalsCallback)callback;
                        Principal principal = httpExchange.getPrincipal();
                        if (principal == null && httpExchange instanceof HttpsExchange) {
                            HttpsExchange httpsExchange = (HttpsExchange)httpExchange;
                            principal = httpsExchange.getSSLSession().getPeerPrincipal();
                        }
                        if (principal == null) continue;
                        principalsCallback.setPeerPrincipals(new Principal[]{principal});
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            httpExchange.setAttribute(this.subjectRequestAttribute, loginContext.getSubject());
            Authenticator.Success success = new Authenticator.Success(new HttpPrincipal(this.nameFromAuthSubject(loginContext.getSubject()), this.realm));
            return success;
        }
        catch (Exception e) {
            Authenticator.Failure failure = new Authenticator.Failure(401);
            return failure;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    protected String extractAuthHeader(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst(AUTHORIZATION_HEADER_NAME);
    }

    protected String nameFromAuthSubject(Subject subject) {
        Iterator<UserPrincipal> iterator = subject.getPrincipals(UserPrincipal.class).iterator();
        if (iterator.hasNext()) {
            Principal p = iterator.next();
            return p.getName();
        }
        return "";
    }
}

