/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.junit.platform.engine.UniqueId;
import org.junit.runner.Description;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.TestSourceProvider;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.junit.vintage.engine.support.UniqueIdReader;
import org.junit.vintage.engine.support.UniqueIdStringifier;

class RunnerTestDescriptorPostProcessor {
    private final UniqueIdReader uniqueIdReader = new UniqueIdReader();
    private final UniqueIdStringifier uniqueIdStringifier = new UniqueIdStringifier();
    private final TestSourceProvider testSourceProvider = new TestSourceProvider();

    RunnerTestDescriptorPostProcessor() {
    }

    void applyFiltersAndCreateDescendants(RunnerTestDescriptor runnerTestDescriptor) {
        this.addChildrenRecursively(runnerTestDescriptor);
        runnerTestDescriptor.applyFilters(this::addChildrenRecursively);
    }

    private void addChildrenRecursively(VintageTestDescriptor parent) {
        if (parent.getDescription().isTest()) {
            return;
        }
        ArrayList<Description> children = parent.getDescription().getChildren();
        Map childrenByUniqueId = children.stream().collect(Collectors.groupingBy(this.uniqueIdReader.andThen(this.uniqueIdStringifier), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (Map.Entry entry : childrenByUniqueId.entrySet()) {
            String uniqueId = (String)entry.getKey();
            List childrenWithSameUniqueId = (List)entry.getValue();
            IntFunction<String> uniqueIdGenerator = this.determineUniqueIdGenerator(uniqueId, childrenWithSameUniqueId);
            for (int index = 0; index < childrenWithSameUniqueId.size(); ++index) {
                String reallyUniqueId = uniqueIdGenerator.apply(index);
                Description description = (Description)childrenWithSameUniqueId.get(index);
                UniqueId id = parent.getUniqueId().append("test", reallyUniqueId);
                VintageTestDescriptor child = new VintageTestDescriptor(id, description, this.testSourceProvider.findTestSource(description));
                parent.addChild(child);
                this.addChildrenRecursively(child);
            }
        }
    }

    private IntFunction<String> determineUniqueIdGenerator(String uniqueId, List<Description> childrenWithSameUniqueId) {
        if (childrenWithSameUniqueId.size() == 1) {
            return index -> uniqueId;
        }
        return index -> uniqueId + "[" + index + "]";
    }
}

