/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import org.jetbrains.annotations.NotNull;

public enum BinaryLengthLength {
    LENGTH_8BIT{

        @Override
        public int code() {
            return 128;
        }

        @Override
        public long initialise(@NotNull BytesOut<?> bytes) {
            bytes.writeUnsignedByte(this.code());
            long pos = bytes.writePosition();
            bytes.writeByte((byte)0);
            return pos;
        }

        @Override
        public void writeLength(@NotNull Bytes<?> bytes, @NonNegative long positionReturnedFromInitialise, @NonNegative long end) {
            long length = end - positionReturnedFromInitialise - 1L & 0xFFFFFFFFL;
            if (length >= 256L) {
                throw this.invalidLength(length);
            }
            bytes.writeByte(positionReturnedFromInitialise, (byte)length);
            UnsafeMemory.MEMORY.storeFence();
        }
    }
    ,
    LENGTH_16BIT{

        @Override
        public int code() {
            return 129;
        }

        @Override
        public long initialise(@NotNull BytesOut<?> bytes) {
            bytes.writeUnsignedByte(this.code());
            long pos = bytes.writePosition();
            bytes.writeShort((short)0);
            return pos;
        }

        @Override
        public void writeLength(@NotNull Bytes<?> bytes, @NonNegative long positionReturnedFromInitialise, @NonNegative long end) {
            long length = end - positionReturnedFromInitialise - 2L & 0xFFFFFFFFL;
            if (length >= 65536L) {
                throw this.invalidLength(length);
            }
            bytes.writeShort(positionReturnedFromInitialise, (short)length);
            UnsafeMemory.MEMORY.storeFence();
        }
    }
    ,
    LENGTH_32BIT{

        @Override
        public int code() {
            return 130;
        }

        @Override
        public long initialise(@NotNull BytesOut<?> bytes) {
            bytes.writeUnsignedByte(this.code());
            long pos = bytes.writePosition();
            bytes.writeInt(0);
            return pos;
        }

        @Override
        public void writeLength(@NotNull Bytes<?> bytes, @NonNegative long positionReturnedFromInitialise, @NonNegative long end) {
            long length = end - positionReturnedFromInitialise - 4L & 0xFFFFFFFFL;
            if (length >= 0x80000000L) {
                throw this.invalidLength(length);
            }
            bytes.writeOrderedInt(positionReturnedFromInitialise, (int)length);
        }
    };

    static final long MASK = 0xFFFFFFFFL;

    IllegalStateException invalidLength(@NonNegative long length) {
        return new IllegalStateException("length: " + length);
    }

    public abstract int code();

    public abstract long initialise(@NotNull BytesOut<?> var1);

    public abstract void writeLength(@NotNull Bytes<?> var1, @NonNegative long var2, @NonNegative long var4);
}

