/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.SelfTestStatus;
import java.util.Objects;

public class SelfTestResult {
    private final SelfTestStatus status;
    private final Throwable throwable;
    public static final SelfTestResult PASS_RESULT = new SelfTestResult(SelfTestStatus.PASSED);

    public SelfTestStatus getStatus() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public SelfTestResult(SelfTestStatus selfTestStatus) {
        if (selfTestStatus == SelfTestStatus.FAILED) {
            throw new IllegalArgumentException("Must provide exception for failed result");
        }
        this.status = selfTestStatus;
        this.throwable = null;
    }

    public SelfTestResult(Throwable throwable) {
        this.status = SelfTestStatus.FAILED;
        this.throwable = throwable;
    }

    public SelfTestResult combine(SelfTestResult selfTestResult) {
        if (this.status.combine(selfTestResult.getStatus()) == this.status) {
            return this;
        }
        return selfTestResult;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SelfTestResult selfTestResult = (SelfTestResult)object;
        return this.status == selfTestResult.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status});
    }

    public String toString() {
        return "SelfTestResult{status=" + (Object)((Object)this.status) + ", throwable=" + this.throwable + '}';
    }
}

