/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.LongTime;
import net.openhft.chronicle.wire.AbstractTimestampLongConverter;

public class NanoTimestampLongConverter
extends AbstractTimestampLongConverter {
    public static final NanoTimestampLongConverter INSTANCE = new NanoTimestampLongConverter();

    public NanoTimestampLongConverter() {
        super(TimeUnit.NANOSECONDS);
    }

    public NanoTimestampLongConverter(String zoneId) {
        super(zoneId, TimeUnit.NANOSECONDS);
    }

    @Override
    protected long parseFormattedDate(ZonedDateTime value) {
        long time = value.getLong(ChronoField.EPOCH_DAY) * 86400000000000L;
        if (value.isSupported(ChronoField.NANO_OF_DAY)) {
            time += value.getLong(ChronoField.NANO_OF_DAY);
        } else if (value.isSupported(ChronoField.MICRO_OF_DAY)) {
            time += value.getLong(ChronoField.MICRO_OF_DAY) * 1000L;
        } else if (value.isSupported(ChronoField.MILLI_OF_DAY)) {
            time += value.getLong(ChronoField.MILLI_OF_DAY) * 1000000L;
        } else if (value.isSupported(ChronoField.SECOND_OF_DAY)) {
            time += value.getLong(ChronoField.SECOND_OF_DAY) * 1000000000L;
        }
        return time;
    }

    @Override
    protected long parseTimestamp(long value, CharSequence text) {
        long number = LongTime.toNanos((long)value);
        if (LongTime.isMicros((long)number)) {
            Jvm.debug().on(this.getClass(), "In input data, replace " + text + " with " + this.asString(number));
        } else if (number != 0L) {
            Jvm.debug().on(this.getClass(), "In input data, replace " + text + " with a real date.");
        }
        return number;
    }

    @Override
    protected void appendFraction(DateTimeFormatterBuilder builder) {
        builder.appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
    }
}

