/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.nodetool.stats.DataPathsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;
import org.apache.cassandra.tools.nodetool.stats.StatsPrinter;

public class DataPathsPrinter<T extends StatsHolder> {
    public static StatsPrinter<DataPathsHolder> from(String format) {
        if ("json".equals(format)) {
            return new StatsPrinter.JsonPrinter<DataPathsHolder>();
        }
        if ("yaml".equals(format)) {
            return new StatsPrinter.YamlPrinter<DataPathsHolder>();
        }
        return new DefaultPrinter();
    }

    public static class DefaultPrinter
    implements StatsPrinter<DataPathsHolder> {
        @Override
        public void print(DataPathsHolder data, PrintStream out) {
            for (Map.Entry<String, Object> entry : data.pathsHash.entrySet()) {
                out.println("Keyspace: " + entry.getKey());
                Map ksPaths = (Map)entry.getValue();
                for (Map.Entry table : ksPaths.entrySet()) {
                    out.println("\tTable: " + (String)table.getKey());
                    out.println("\tPaths:");
                    for (String path : (List)table.getValue()) {
                        out.println("\t\t" + path);
                    }
                    out.println("");
                }
            }
        }
    }
}

