/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.StreamSummary;

public class SessionSummary {
    public final InetSocketAddress coordinator;
    public final InetSocketAddress peer;
    public final Collection<StreamSummary> receivingSummaries;
    public final Collection<StreamSummary> sendingSummaries;
    public static IVersionedSerializer<SessionSummary> serializer = new IVersionedSerializer<SessionSummary>(){

        @Override
        public void serialize(SessionSummary summary, DataOutputPlus out, int version) throws IOException {
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(summary.coordinator, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(summary.peer, out, version);
            out.writeInt(summary.receivingSummaries.size());
            for (StreamSummary streamSummary : summary.receivingSummaries) {
                StreamSummary.serializer.serialize(streamSummary, out, version);
            }
            out.writeInt(summary.sendingSummaries.size());
            for (StreamSummary streamSummary : summary.sendingSummaries) {
                StreamSummary.serializer.serialize(streamSummary, out, version);
            }
        }

        @Override
        public SessionSummary deserialize(DataInputPlus in, int version) throws IOException {
            InetAddressAndPort coordinator = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort peer = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            int numRcvd = in.readInt();
            ArrayList<StreamSummary> receivingSummaries = new ArrayList<StreamSummary>(numRcvd);
            for (int i = 0; i < numRcvd; ++i) {
                receivingSummaries.add((StreamSummary)StreamSummary.serializer.deserialize(in, version));
            }
            int numSent = in.readInt();
            ArrayList<StreamSummary> sendingSummaries = new ArrayList<StreamSummary>(numRcvd);
            for (int i = 0; i < numSent; ++i) {
                sendingSummaries.add((StreamSummary)StreamSummary.serializer.deserialize(in, version));
            }
            return new SessionSummary(coordinator, peer, receivingSummaries, sendingSummaries);
        }

        @Override
        public long serializedSize(SessionSummary summary, int version) {
            long size = 0L;
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(summary.coordinator, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(summary.peer, version);
            size += (long)TypeSizes.sizeof(summary.receivingSummaries.size());
            for (StreamSummary streamSummary : summary.receivingSummaries) {
                size += StreamSummary.serializer.serializedSize(streamSummary, version);
            }
            size += (long)TypeSizes.sizeof(summary.sendingSummaries.size());
            for (StreamSummary streamSummary : summary.sendingSummaries) {
                size += StreamSummary.serializer.serializedSize(streamSummary, version);
            }
            return size;
        }
    };

    public SessionSummary(InetSocketAddress coordinator, InetSocketAddress peer, Collection<StreamSummary> receivingSummaries, Collection<StreamSummary> sendingSummaries) {
        assert (coordinator != null);
        assert (peer != null);
        assert (receivingSummaries != null);
        assert (sendingSummaries != null);
        this.coordinator = coordinator;
        this.peer = peer;
        this.receivingSummaries = receivingSummaries;
        this.sendingSummaries = sendingSummaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionSummary summary = (SessionSummary)o;
        if (!this.coordinator.equals(summary.coordinator)) {
            return false;
        }
        if (!this.peer.equals(summary.peer)) {
            return false;
        }
        if (!this.receivingSummaries.equals(summary.receivingSummaries)) {
            return false;
        }
        return this.sendingSummaries.equals(summary.sendingSummaries);
    }

    public int hashCode() {
        int result = this.coordinator.hashCode();
        result = 31 * result + this.peer.hashCode();
        result = 31 * result + this.receivingSummaries.hashCode();
        result = 31 * result + this.sendingSummaries.hashCode();
        return result;
    }
}

