/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.RepairMetrics;
import org.apache.cassandra.repair.AbstractRepairTask;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.CoordinatedRepairResult;
import org.apache.cassandra.repair.RepairCoordinator;
import org.apache.cassandra.repair.RepairResult;
import org.apache.cassandra.repair.RepairSessionResult;
import org.apache.cassandra.repair.Scheduler;
import org.apache.cassandra.repair.SyncStat;
import org.apache.cassandra.repair.consistent.SyncStatSummary;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.DiagnosticSnapshotService;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;

public class PreviewRepairTask
extends AbstractRepairTask {
    private final TimeUUID parentSession;
    private final List<CommonRange> commonRanges;
    private final String[] cfnames;
    private volatile String successMessage = this.name() + " completed successfully";

    protected PreviewRepairTask(RepairCoordinator coordinator, TimeUUID parentSession, List<CommonRange> commonRanges, String[] cfnames) {
        super(coordinator);
        this.parentSession = parentSession;
        this.commonRanges = commonRanges;
        this.cfnames = cfnames;
    }

    @Override
    public String name() {
        return "Repair preview";
    }

    @Override
    public String successMessage() {
        return this.successMessage;
    }

    @Override
    public Future<CoordinatedRepairResult> performUnsafe(ExecutorPlus executor, Scheduler validationScheduler) {
        Future<CoordinatedRepairResult> f = this.runRepair(this.parentSession, false, executor, validationScheduler, this.commonRanges, this.cfnames);
        return f.map(result -> {
            Object message;
            if (result.hasFailed()) {
                return result;
            }
            PreviewKind previewKind = this.options.getPreviewKind();
            Preconditions.checkState((previewKind != PreviewKind.NONE ? 1 : 0) != 0, (Object)"Preview is NONE");
            SyncStatSummary summary = new SyncStatSummary(true);
            summary.consumeSessionResults(result.results);
            if (summary.isEmpty()) {
                message = previewKind == PreviewKind.REPAIRED ? "Repaired data is in sync" : "Previewed data was in sync";
            } else {
                message = (previewKind == PreviewKind.REPAIRED ? "Repaired data is inconsistent\n" : "Preview complete\n") + summary;
                RepairMetrics.previewFailures.inc();
                if (previewKind == PreviewKind.REPAIRED) {
                    this.maybeSnapshotReplicas(this.parentSession, this.keyspace, result.results.get());
                }
            }
            this.successMessage = this.successMessage + "; " + (String)message;
            this.coordinator.notification((String)message);
            return result;
        });
    }

    private void maybeSnapshotReplicas(TimeUUID parentSession, String keyspace, List<RepairSessionResult> results) {
        if (!DatabaseDescriptor.snapshotOnRepairedDataMismatch()) {
            return;
        }
        try {
            HashSet<String> mismatchingTables = new HashSet<String>();
            HashSet<InetAddressAndPort> nodes = new HashSet<InetAddressAndPort>();
            HashSet ranges = new HashSet();
            for (RepairSessionResult sessionResult : results) {
                for (RepairResult repairResult : PreviewRepairTask.emptyIfNull(sessionResult.repairJobResults)) {
                    for (SyncStat stat : PreviewRepairTask.emptyIfNull(repairResult.stats)) {
                        if (!stat.differences.isEmpty()) {
                            mismatchingTables.add(repairResult.desc.columnFamily);
                            ranges.addAll(stat.differences);
                        }
                        nodes.add(stat.nodes.coordinator);
                        nodes.add(stat.nodes.peer);
                    }
                }
            }
            String snapshotName = DiagnosticSnapshotService.getSnapshotName("RepairedDataMismatch-");
            for (String table : mismatchingTables) {
                if (!Keyspace.open(keyspace).getColumnFamilyStore(table).snapshotExists(snapshotName)) {
                    List<Range<Token>> normalizedRanges = Range.normalize(ranges);
                    logger.info("{} Snapshotting {}.{} for preview repair mismatch for ranges {} with tag {} on instances {}", new Object[]{this.options.getPreviewKind().logPrefix(parentSession), keyspace, table, normalizedRanges, snapshotName, nodes});
                    DiagnosticSnapshotService.repairedDataMismatch(Keyspace.open(keyspace).getColumnFamilyStore(table).metadata(), nodes, normalizedRanges);
                    continue;
                }
                logger.info("{} Not snapshotting {}.{} - snapshot {} exists", new Object[]{this.options.getPreviewKind().logPrefix(parentSession), keyspace, table, snapshotName});
            }
        }
        catch (Exception e) {
            logger.error("{} Failed snapshotting replicas", (Object)this.options.getPreviewKind().logPrefix(parentSession), (Object)e);
        }
    }

    private static <T> Iterable<T> emptyIfNull(Iterable<T> iter) {
        if (iter == null) {
            return Collections.emptyList();
        }
        return iter;
    }
}

