/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CorruptFileException;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.SimpleChunkReader;
import org.apache.cassandra.utils.ByteBufferUtil;

class ChecksummedRebufferer
extends BufferManagingRebufferer {
    private final DataIntegrityMetadata.ChecksumValidator validator;

    ChecksummedRebufferer(ChannelProxy channel, DataIntegrityMetadata.ChecksumValidator validator) {
        super(new SimpleChunkReader(channel, channel.size(), BufferType.ON_HEAP, validator.chunkSize));
        this.validator = validator;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long desiredPosition) {
        if (desiredPosition != this.offset + (long)this.buffer.position()) {
            this.validator.seek(desiredPosition);
        }
        this.offset = this.alignedPosition(desiredPosition);
        this.source.readChunk(this.offset, this.buffer);
        try {
            this.validator.validate(ByteBufferUtil.getArray(this.buffer), 0, this.buffer.remaining());
        }
        catch (IOException e) {
            throw new CorruptFileException(e, this.channel().filePath());
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.source.close();
        }
        finally {
            this.validator.close();
        }
    }

    @Override
    long alignedPosition(long desiredPosition) {
        return desiredPosition / (long)this.buffer.capacity() * (long)this.buffer.capacity();
    }
}

