/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SSTableContextManager {
    private static final Logger logger = LoggerFactory.getLogger(SSTableContextManager.class);
    private final ConcurrentHashMap<SSTableReader, SSTableContext> sstableContexts = new ConcurrentHashMap();

    public Pair<Set<SSTableContext>, Set<SSTableReader>> update(Collection<SSTableReader> removed, Iterable<SSTableReader> added, IndexValidation validation) {
        this.release(removed);
        HashSet<SSTableContext> contexts = new HashSet<SSTableContext>();
        HashSet<SSTableReader> invalid = new HashSet<SSTableReader>();
        for (SSTableReader sstable : added) {
            IndexDescriptor indexDescriptor;
            if (sstable.isMarkedCompacted() || !(indexDescriptor = IndexDescriptor.create(sstable)).isPerSSTableIndexBuildComplete()) continue;
            try {
                if (!this.sstableContexts.containsKey(sstable) && !indexDescriptor.validatePerSSTableComponents(validation, true, false)) {
                    invalid.add(sstable);
                    this.removeInvalidSSTableContext(sstable);
                    continue;
                }
                contexts.add(this.sstableContexts.computeIfAbsent(sstable, SSTableContext::create));
            }
            catch (Throwable t) {
                logger.warn(indexDescriptor.logMessage("Failed to update per-SSTable components for SSTable {}"), (Object)sstable.descriptor, (Object)t);
                invalid.add(sstable);
                this.removeInvalidSSTableContext(sstable);
            }
        }
        return Pair.create(contexts, invalid);
    }

    public void release(Collection<SSTableReader> toRelease) {
        toRelease.stream().map(this.sstableContexts::remove).filter(Objects::nonNull).forEach(SharedCloseableImpl::close);
    }

    int openFiles() {
        return this.sstableContexts.values().stream().mapToInt(SSTableContext::openFilesPerSSTable).sum();
    }

    long diskUsage() {
        return this.sstableContexts.values().stream().mapToLong(SSTableContext::diskUsage).sum();
    }

    Set<SSTableReader> sstables() {
        return this.sstableContexts.keySet();
    }

    @VisibleForTesting
    public int size() {
        return this.sstableContexts.size();
    }

    @VisibleForTesting
    public void clear() {
        this.sstableContexts.values().forEach(SharedCloseableImpl::close);
        this.sstableContexts.clear();
    }

    private void removeInvalidSSTableContext(SSTableReader sstable) {
        SSTableContext ignored = this.sstableContexts.remove(sstable);
        if (ignored != null) {
            ignored.close();
        }
    }
}

