/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ExpirationDateOverflowHandling;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.db.rows.AbstractCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.ByteBufferCloner;

public class BufferCell
extends AbstractCell<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferCell(ColumnMetadata.regularColumn("", "", "", ByteType.instance), 0L, 0, 0, ByteBufferUtil.EMPTY_BYTE_BUFFER, null));
    private final long timestamp;
    private final int ttl;
    private final int localDeletionTimeUnsignedInteger;
    private final ByteBuffer value;
    private final CellPath path;

    public BufferCell(ColumnMetadata column, long timestamp, int ttl, long localDeletionTime, ByteBuffer value, CellPath path) {
        this(column, timestamp, ttl, BufferCell.deletionTimeLongToUnsignedInteger(localDeletionTime), value, path);
    }

    public BufferCell(ColumnMetadata column, long timestamp, int ttl, int localDeletionTimeUnsignedInteger, ByteBuffer value, CellPath path) {
        super(column);
        assert (!column.isPrimaryKeyColumn());
        assert (column.isComplex() == (path != null)) : String.format("Column %s.%s(%s: %s) isComplex: %b with cellpath: %s", column.ksName, column.cfName, column.name, column.type.toString(), column.isComplex(), path);
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTimeUnsignedInteger = localDeletionTimeUnsignedInteger;
        this.value = value;
        this.path = path;
    }

    public static BufferCell live(ColumnMetadata column, long timestamp, ByteBuffer value) {
        return BufferCell.live(column, timestamp, value, null);
    }

    public static BufferCell live(ColumnMetadata column, long timestamp, ByteBuffer value, CellPath path) {
        return new BufferCell(column, timestamp, 0, Long.MAX_VALUE, value, path);
    }

    public static BufferCell expiring(ColumnMetadata column, long timestamp, int ttl, long nowInSec, ByteBuffer value) {
        return BufferCell.expiring(column, timestamp, ttl, nowInSec, value, null);
    }

    public static BufferCell expiring(ColumnMetadata column, long timestamp, int ttl, long nowInSec, ByteBuffer value, CellPath path) {
        assert (ttl != 0);
        return new BufferCell(column, timestamp, ttl, ExpirationDateOverflowHandling.computeLocalExpirationTime(nowInSec, ttl), value, path);
    }

    public static BufferCell tombstone(ColumnMetadata column, long timestamp, long nowInSec) {
        return BufferCell.tombstone(column, timestamp, nowInSec, null);
    }

    public static BufferCell tombstone(ColumnMetadata column, long timestamp, long nowInSec, CellPath path) {
        return new BufferCell(column, timestamp, 0, nowInSec, ByteBufferUtil.EMPTY_BYTE_BUFFER, path);
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int ttl() {
        return this.ttl;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    @Override
    public ValueAccessor<ByteBuffer> accessor() {
        return ByteBufferAccessor.instance;
    }

    @Override
    public CellPath path() {
        return this.path;
    }

    @Override
    public Cell<?> withUpdatedColumn(ColumnMetadata newColumn) {
        return new BufferCell(newColumn, this.timestamp, this.ttl, this.localDeletionTimeUnsignedInteger, this.value, this.path);
    }

    @Override
    public Cell<?> withUpdatedValue(ByteBuffer newValue) {
        return new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTimeUnsignedInteger, newValue, this.path);
    }

    @Override
    public Cell<?> withUpdatedTimestampAndLocalDeletionTime(long newTimestamp, long newLocalDeletionTime) {
        return new BufferCell(this.column, newTimestamp, this.ttl, newLocalDeletionTime, this.value, this.path);
    }

    @Override
    public Cell<?> withSkippedValue() {
        return this.withUpdatedValue(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.value) + (this.path == null ? 0L : this.path.unsharedHeapSize());
    }

    @Override
    public Cell<?> clone(ByteBufferCloner cloner) {
        if (!this.value.hasRemaining() && this.path == null) {
            return this;
        }
        return super.clone(cloner);
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingDataOf(this.value) + (this.path == null ? 0L : this.path.unsharedHeapSizeExcludingData());
    }

    @Override
    protected int localDeletionTimeAsUnsignedInt() {
        return this.localDeletionTimeUnsignedInteger;
    }
}

