/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.LineNumberAware;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.component.log.LogProducer;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.MaskingFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.processor.CamelLogProcessor;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.processor.DefaultMaskingFormatter;
import org.apache.camel.support.processor.ThroughputLogger;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;

@UriEndpoint(firstVersion="1.1.0", scheme="log", title="Log Data", remote=false, syntax="log:loggerName", producerOnly=true, category={Category.CORE, Category.MONITORING})
public class LogEndpoint
extends ProcessorEndpoint
implements LineNumberAware {
    private volatile Processor logger;
    private Logger providedLogger;
    private ExchangeFormatter localFormatter;
    private int lineNumber;
    private String location;
    @UriPath(description="Name of the logging category to use")
    @Metadata(required=true)
    private String loggerName;
    @UriParam(defaultValue="INFO", enums="TRACE,DEBUG,INFO,WARN,ERROR,OFF")
    private String level;
    @UriParam
    private String marker;
    @UriParam
    private Integer groupSize;
    @UriParam
    private Long groupInterval;
    @UriParam(defaultValue="true")
    private boolean groupActiveOnly = true;
    @UriParam
    private Long groupDelay;
    @UriParam
    private Boolean logMask;
    @UriParam(label="advanced")
    private ExchangeFormatter exchangeFormatter;
    @UriParam(label="formatting", description="Show route ID.")
    private boolean showRouteId;
    @UriParam(label="formatting", description="Show route Group.")
    private boolean showRouteGroup;
    @UriParam(label="formatting", description="Show the unique exchange ID.")
    private boolean showExchangeId;
    @UriParam(label="formatting", description="Shows the Message Exchange Pattern (or MEP for short).")
    private boolean showExchangePattern;
    @UriParam(label="formatting", description="Show the exchange properties (only custom). Use showAllProperties to show both internal and custom properties.")
    private boolean showProperties;
    @UriParam(label="formatting", description="Show all of the exchange properties (both internal and custom).")
    private boolean showAllProperties;
    @UriParam(label="formatting", description="Show the variables.")
    private boolean showVariables;
    @UriParam(label="formatting", description="Show the message headers.")
    private boolean showHeaders;
    @UriParam(label="formatting", defaultValue="true", description="Whether to skip line separators when logging the message body. This allows to log the message body in one line, setting this option to false will preserve any line separators from the body, which then will log the body as is.")
    private boolean skipBodyLineSeparator = true;
    @UriParam(label="formatting", defaultValue="true", description="Show the message body.")
    private boolean showBody = true;
    @UriParam(label="formatting", defaultValue="true", description="Show the body Java type.")
    private boolean showBodyType = true;
    @UriParam(label="formatting", description="If the exchange has an exception, show the exception message (no stacktrace)")
    private boolean showException;
    @UriParam(label="formatting", description="If the exchange has a caught exception, show the exception message (no stack trace). A caught exception is stored as a property on the exchange (using the key org.apache.camel.Exchange#EXCEPTION_CAUGHT) and for instance a doCatch can catch exceptions.")
    private boolean showCaughtException;
    @UriParam(label="formatting", description="Show the stack trace, if an exchange has an exception. Only effective if one of showAll, showException or showCaughtException are enabled.")
    private boolean showStackTrace;
    @UriParam(label="formatting", description="Quick option for turning all options on. (multiline, maxChars has to be manually set if to be used)")
    private boolean showAll;
    @UriParam(label="formatting", description="If enabled then each information is outputted on a newline.")
    private boolean multiline;
    @UriParam(label="formatting", description="If enabled Camel will on Future objects wait for it to complete to obtain the payload to be logged.")
    private boolean showFuture;
    @UriParam(label="formatting", defaultValue="true", description="Whether Camel should show cached stream bodies or not (org.apache.camel.StreamCache).")
    private boolean showCachedStreams = true;
    @UriParam(label="formatting", description="Whether Camel should show stream bodies or not (eg such as java.io.InputStream). Beware if you enable this option then you may not be able later to access the message body as the stream have already been read by this logger. To remedy this you will have to use Stream Caching.")
    private boolean showStreams;
    @UriParam(label="formatting", description="If enabled Camel will output files")
    private boolean showFiles;
    @UriParam(label="formatting", defaultValue="10000", description="Limits the number of characters logged per line.")
    private int maxChars = 10000;
    @UriParam(label="formatting", enums="Default,Tab,Fixed", defaultValue="Default", description="Sets the outputs style to use.")
    private DefaultExchangeFormatter.OutputStyle style = DefaultExchangeFormatter.OutputStyle.Default;
    @UriParam(defaultValue="false", description="If enabled only the body will be printed out")
    private boolean plain;
    @UriParam(description="If enabled then the source location of where the log endpoint is used in Camel routes, would be used as logger name, instead of the given name. However, if the source location is disabled or not possible to resolve then the existing logger name will be used.")
    private boolean sourceLocationLoggerName;

    public LogEndpoint() {
    }

    public LogEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public LogEndpoint(String endpointUri, Component component, Processor logger) {
        super(endpointUri, component);
        this.setLogger(logger);
    }

    public boolean isRemote() {
        return false;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.getComponent() == null) {
            this.setComponent(this.getCamelContext().getComponent("log"));
        }
        this.localFormatter = this.exchangeFormatter;
        if (this.localFormatter == null) {
            boolean changed = this.showExchangePattern || !this.skipBodyLineSeparator || !this.showBody || !this.showBodyType || this.maxChars != 10000 || this.style != DefaultExchangeFormatter.OutputStyle.Default || this.plain;
            changed |= this.showRouteId || this.showRouteGroup;
            changed |= this.showExchangeId || this.showProperties || this.showAllProperties || this.showVariables || this.showHeaders || this.showException || this.showCaughtException || this.showStackTrace;
            if (changed |= this.showAll || this.multiline || this.showFuture || !this.showCachedStreams || this.showStreams || this.showFiles) {
                DefaultExchangeFormatter def = new DefaultExchangeFormatter();
                def.setPlain(this.plain);
                def.setShowRouteId(this.showRouteId);
                def.setShowRouteGroup(this.showRouteGroup);
                def.setShowAll(this.showAll);
                def.setShowBody(this.showBody);
                def.setShowBodyType(this.showBodyType);
                def.setShowCaughtException(this.showCaughtException);
                def.setShowException(this.showException);
                def.setShowExchangeId(this.showExchangeId);
                def.setShowExchangePattern(this.showExchangePattern);
                def.setShowFiles(this.showFiles);
                def.setShowFuture(this.showFuture);
                def.setShowHeaders(this.showHeaders);
                def.setShowVariables(this.showVariables);
                def.setShowProperties(this.showProperties);
                def.setShowAllProperties(this.showAllProperties);
                def.setShowStackTrace(this.showStackTrace);
                def.setShowCachedStreams(this.showCachedStreams);
                def.setShowStreams(this.showStreams);
                def.setMaxChars(this.maxChars);
                def.setMultiline(this.multiline);
                def.setSkipBodyLineSeparator(this.skipBodyLineSeparator);
                def.setStyle(this.style);
                this.localFormatter = def;
            } else {
                this.localFormatter = this.getComponent().getDefaultExchangeFormatter();
            }
        }
    }

    protected void doStart() throws Exception {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        ServiceHelper.startService((Object)this.logger);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.logger);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setLogger(Processor logger) {
        this.logger = logger;
        this.setProcessor(this.logger);
    }

    public Processor getLogger() {
        return this.logger;
    }

    public Producer createProducer() throws Exception {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        ServiceHelper.startService((Object)this.logger);
        return new LogProducer((Endpoint)this, this.logger);
    }

    protected String createEndpointUri() {
        return "log:" + this.logger.toString();
    }

    public LogComponent getComponent() {
        return (LogComponent)super.getComponent();
    }

    protected Processor createLogger() {
        ThroughputLogger answer;
        CamelLogger camelLogger;
        LoggingLevel loggingLevel = LoggingLevel.INFO;
        if (this.level != null && !this.level.equals("INFO")) {
            loggingLevel = LoggingLevel.valueOf((String)this.level);
        }
        if (this.providedLogger == null) {
            String name = this.loggerName;
            if (this.sourceLocationLoggerName && (name = LoggerHelper.getLineNumberLoggerName((Object)((Object)this))) == null) {
                name = this.loggerName;
            }
            camelLogger = new CamelLogger(name, loggingLevel, this.getMarker());
        } else {
            camelLogger = new CamelLogger(this.providedLogger, loggingLevel, this.getMarker());
        }
        if (this.getGroupSize() != null) {
            answer = new ThroughputLogger(camelLogger, this.getGroupSize());
        } else if (this.getGroupInterval() != null) {
            Long groupDelay = this.getGroupDelay();
            answer = new ThroughputLogger(camelLogger, this.getCamelContext(), this.getGroupInterval(), groupDelay, Boolean.valueOf(this.groupActiveOnly));
        } else {
            answer = new CamelLogProcessor(camelLogger, this.localFormatter, this.getMaskingFormatter(), this.getCamelContext().getCamelContextExtension().getLogListeners());
        }
        this.setProcessor((Processor)answer);
        return answer;
    }

    private MaskingFormatter getMaskingFormatter() {
        if ((this.logMask != null ? this.logMask : this.getCamelContext().isLogMask()).booleanValue()) {
            MaskingFormatter formatter = (MaskingFormatter)this.getCamelContext().getRegistry().lookupByNameAndType("CamelCustomLogMask", MaskingFormatter.class);
            if (formatter == null) {
                formatter = new DefaultMaskingFormatter();
            }
            return formatter;
        }
        return null;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Long getGroupInterval() {
        return this.groupInterval;
    }

    public void setGroupInterval(Long groupInterval) {
        this.groupInterval = groupInterval;
    }

    public boolean isGroupActiveOnly() {
        return this.groupActiveOnly;
    }

    public void setGroupActiveOnly(boolean groupActiveOnly) {
        this.groupActiveOnly = groupActiveOnly;
    }

    public Long getGroupDelay() {
        return this.groupDelay;
    }

    public void setGroupDelay(Long groupDelay) {
        this.groupDelay = groupDelay;
    }

    public Logger getProvidedLogger() {
        return this.providedLogger;
    }

    public void setProvidedLogger(Logger providedLogger) {
        this.providedLogger = providedLogger;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Boolean getLogMask() {
        return this.logMask;
    }

    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    public boolean isShowRouteId() {
        return this.showRouteId;
    }

    public void setShowRouteId(boolean showRouteId) {
        this.showRouteId = showRouteId;
    }

    public boolean isShowRouteGroup() {
        return this.showRouteGroup;
    }

    public void setShowRouteGroup(boolean showRouteGroup) {
        this.showRouteGroup = showRouteGroup;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowExchangePattern() {
        return this.showExchangePattern;
    }

    public void setShowExchangePattern(boolean showExchangePattern) {
        this.showExchangePattern = showExchangePattern;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowAllProperties() {
        return this.showAllProperties;
    }

    public void setShowAllProperties(boolean showAllProperties) {
        this.showAllProperties = showAllProperties;
    }

    public boolean isShowVariables() {
        return this.showVariables;
    }

    public void setShowVariables(boolean showVariables) {
        this.showVariables = showVariables;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isSkipBodyLineSeparator() {
        return this.skipBodyLineSeparator;
    }

    public void setSkipBodyLineSeparator(boolean skipBodyLineSeparator) {
        this.skipBodyLineSeparator = skipBodyLineSeparator;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public boolean isShowCaughtException() {
        return this.showCaughtException;
    }

    public void setShowCaughtException(boolean showCaughtException) {
        this.showCaughtException = showCaughtException;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isShowFuture() {
        return this.showFuture;
    }

    public void setShowFuture(boolean showFuture) {
        this.showFuture = showFuture;
    }

    public boolean isShowCachedStreams() {
        return this.showCachedStreams;
    }

    public void setShowCachedStreams(boolean showCachedStreams) {
        this.showCachedStreams = showCachedStreams;
    }

    public boolean isShowStreams() {
        return this.showStreams;
    }

    public void setShowStreams(boolean showStreams) {
        this.showStreams = showStreams;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean showFiles) {
        this.showFiles = showFiles;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public DefaultExchangeFormatter.OutputStyle getStyle() {
        return this.style;
    }

    public void setStyle(DefaultExchangeFormatter.OutputStyle style) {
        this.style = style;
    }

    public boolean isPlain() {
        return this.plain;
    }

    public void setPlain(boolean plain) {
        this.plain = plain;
    }

    public boolean isSourceLocationLoggerName() {
        return this.sourceLocationLoggerName;
    }

    public void setSourceLocationLoggerName(boolean sourceLocationLoggerName) {
        this.sourceLocationLoggerName = sourceLocationLoggerName;
    }
}

