/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.DisabledAware;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class DelegateSyncProcessor
extends ServiceSupport
implements DelegateProcessor,
AsyncProcessor,
Navigate<Processor>,
DisabledAware {
    protected final Processor processor;
    private boolean disabled;

    public DelegateSyncProcessor(Processor processor) {
        this.processor = processor;
    }

    public String toString() {
        return "DelegateSync[" + String.valueOf(this.processor) + "]";
    }

    public Processor getProcessor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processor.process(exchange);
        }
        catch (Exception | LinkageError e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    public void process(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    public boolean hasNext() {
        return this.processor != null;
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }
}

